function [x,y,err,xlab,ylab,titl]=Mc1Dload(monitor)
%
% Loads McStas 1d output
%

currdir = pwd;

[PATHSTR,NAME,EXT] = fileparts(monitor);

if (length(PATHSTR)>0)
  cd(PATHSTR);
end

if (length(EXT)>0)
  NAME = [NAME EXT];
end

% Strip off header and load the data
unix(['grep -v \# ' NAME ' > mcstas.raw']);
data = load('mcstas.raw');

[tmp,xlab] = unix(['grep xlabel ' NAME ' |cut -f2 -d:']);
[tmp,ylab] = unix(['grep ylabel ' NAME ' |cut -f2 -d:']);
[tmp,stats] = unix(['grep statistics ' NAME ' |cut -f2 -d:']);
[tmp,vals] = unix(['grep values ' NAME ' |cut -f2 -d:']);
[tmp,comp] = unix(['grep component ' NAME ' |cut -f2 -d:']);
[tmp,xylims] = unix(['grep xylimits ' NAME ' |cut -f2 -d:']);
xylims=str2num(xylims);
siz = size(data);
titl=['[' monitor ']' comp vals stats];

x = data(:,1);
y = data(:,2);
err = data(:,3);

cd(currdir);