function [x,y,data,z,xlab,ylab,titl]=Mc2Dload(monitor)
%
% Loads McStas 2d output
%

currdir = pwd;

[PATHSTR,NAME,EXT] = fileparts(monitor);

if (length(PATHSTR)>0)
  cd(PATHSTR);
end

if (length(EXT)>0)
  NAME = [NAME EXT];
end

% Strip off header and load the data
unix(['grep -v \# ' NAME ' > mcstas.raw']);
data = load('mcstas.raw');
siz = size(data);
data=data(1:siz(1)/3,:);
data=data';

[tmp,xlab] = unix(['grep xlabel ' NAME ' |cut -f2 -d:']);
[tmp,ylab] = unix(['grep ylabel ' NAME ' |cut -f2 -d:']);
[tmp,stats] = unix(['grep statistics ' NAME ' |cut -f2 -d:']);
[tmp,vals] = unix(['grep values ' NAME ' |cut -f2 -d:']);
[tmp,comp] = unix(['grep component ' NAME ' |cut -f2 -d:']);
[tmp,xylims] = unix(['grep xylimits ' NAME ' |cut -f2 -d:']);
xylims=str2num(xylims);
siz = size(data);
titl=['[' monitor ']' comp vals stats];

x = linspace(xylims(1),xylims(2),siz(1));
y = linspace(xylims(3),xylims(4),siz(1));
z = [xylims(5) xylims(6)];

cd(currdir);