function [x,y,err,xlab,ylab,titl]=McScanLoad(directory,N)
%
% Loads McStas scan output.
%

currdir = pwd;

cd(directory)


% Strip off header and load the data
unix('grep -v \# mcstas.dat > mcstas.raw');
data = load('mcstas.raw');
[tmp,xlab] = unix('grep xlabel mcstas.dat |cut -f2 -d:');
[tmp,ylab] = unix('grep ylabel mcstas.dat |cut -f2 -d:');
%ylab = [ylab ' per monitor'];
ylab = 'Intensity';
[tmp,titl] = unix('grep title mcstas.dat |cut -f2 -d:');

siz = size(data);
x = data(:,1); % Scanned variable
data = data(:,2:end); % Detectors
siz = size(data);
if (N <= siz(2)/2)
  y = data(:,2*(N-1)+1);
  err = data(:,2*(N-1)+2);
else
  error(['You asked for detector number ' num2str(N) ' of ' num2str(siz(2)/2) ' which is not possible...']);
end
cd(currdir);