'''
Created on 21 Jan 2015

@author: Deon Marais (deon.marais@necsa.co.za)
@organization: The South African Nuclear Energy Corporation (Necsa) SOC Limited
@copyright: See copyright.txt
'''

import PyQt4.QtGui as qt
from PyQt4 import QtCore
import time


#**************************************************************
def getprettyduration(seconds):
    if seconds / 3600 > 1.0:
        prettyduration = "%.0fh %.0fmin" %(seconds / 3600, (seconds % 3600)/3600*60)
    elif seconds / 60.0 > 1.0:
        prettyduration = "%.0fmin %.0fsec" %(seconds / 60, seconds % 60)
    else:
        prettyduration = "%.1fsec" %(seconds)
    return prettyduration
            
            
#**************************************************************
class ProgressBar():
    def __init__(self,title, nrofsteps,info=""):
        self.inittime = time.time()
        self.endtime = time.time()
        self.timeln = ""
        
        self.stepnr = 1
        self.nrofsteps=nrofsteps
        self.progress=qt.QProgressDialog()
        self.progress = qt.QProgressDialog()
        self.progress.setWindowTitle(title)
        self.info = info
        self.setinfo(self.info)
        self.currvalue = 0
        self.progress.setValue(self.currvalue)   
        self.progress.show()
        QtCore.QCoreApplication.instance().processEvents() 
        self.increment = 100.0/float(nrofsteps)


        
        
    def step(self,info=""):
        self.endtime = time.time()
        totrunningtime = self.endtime - self.inittime
        deltatime = totrunningtime/self.stepnr
        predictedtottime = self.nrofsteps * deltatime
        remainingtime = predictedtottime - totrunningtime
        
        remainingstr = getprettyduration(remainingtime)
        predictedtottimestr = getprettyduration(predictedtottime)
        
        if info != "": self.info = info
        self.currvalue = self.currvalue+self.increment
        self.stepnr = self.stepnr + 1
        stepsln = "%i of %i" %(self.stepnr,self.nrofsteps)
        self.timeln = remainingstr + " remaining of " + predictedtottimestr
        
        self.progress.setLabelText("%s\n%s\n%s" %(stepsln,self.timeln,self.info))
        self.progress.setValue(int(self.currvalue))
        QtCore.QCoreApplication.instance().processEvents()
    
    
    def setinfo(self,info=""):
        if info !="": self.info = info
        stepsln = "%i of %i\n" %(self.stepnr,self.nrofsteps)
        self.progress.setLabelText("%s\n%s\n%s" %(stepsln,self.timeln,self.info))
        QtCore.QCoreApplication.instance().processEvents()
        
    def wasCanceled(self):
        return self.progress.wasCanceled()
        