'''
Created on 21 Jan 2015

@author: Deon Marais (deon.marais@necsa.co.za)
@organization: The South African Nuclear Energy Corporation (Necsa) SOC Limited
@copyright: See copyright.txt
'''

from PyQt4.QtGui import QMainWindow as QMainWindow
from McPSGUI import Ui_MainWindow
from PyQt4.QtGui import QFileDialog
import PyQt4 as qt
import os
import McPS

class McPSDEF (QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.filedialog = QFileDialog()
        #self.filedialog.setDirectory("Session")
        self.filedialog.setViewMode(QFileDialog.Detail)
        self.filedialog.setFileMode(QFileDialog.ExistingFile)
        self.file_types = "All (*.*);; Instrument (*.instr);; Parameter Study (*.parst);; Commands (*.cmds)"
        self.selectedfilter = "All (*.*)"
        self.selecteddir = os.path.dirname(str(self.filedialog.history()[0]))
        
    def open_Button_pressed(self):
        #The native Windows dialog: Struggled with getting the selectedfilter to work, so changed to using QT's implementation of dialog
        #fname = self.filedialog.getOpenFileName(self, 'Open file', self.selecteddir, self.file_types, self.selectedfilter , QFileDialog.DontUseNativeDialog)
        fname = self.filedialog.getOpenFileName(self, 'Open file', self.selecteddir, self.file_types, self.selectedfilter)

        if (fname==''): return
        self.filedialog.setDirectory(os.path.dirname(str(fname)))
        suffix = os.path.splitext(str(fname))[-1]
        
        if suffix == ".instr":
            newfile = McPS.GenPSBase(fname)
            self.selectedfilter = "Parameter Study (*.parst)"
        elif suffix == ".parst":
            newfile = McPS.GenPSCmds(fname)
            self.selectedfilter = "Commands (*.cmds)"
        elif suffix == ".cmds":
            McPS.RunPSCmds(fname)
            self.selectedfilter = "All (*.*)"
            True
        
        #self.selecteddir = os.path.dirname(str(newfile))
        #self.filedialog.selectFilter("Parameter Study (*.parst)")
        True
