/* Routines to interface 'conrec.cpp' and MC2D */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "mc2d.h"

/* Set limit of 1e5 contour lines */
static struct mc2d_contour_line contour_lines[100000];
static int ncontour_lines;



/* Get 'conrec' to make contours for the data in 'p' */
 void calc_contour_lines(struct mc2d_image_2d *p, int nc)
{
  int i;
  float **p_array, *x,*y;
  float *z;
  int nx=p->x_width, ny=p->y_height;

/* Calculate 'nc' contour levels up to p->data_max */
/* We deliberately exclude the zero contour */
  z=(float *)malloc(nc*sizeof(float));
  for(i=0; i<nc; i++)
    z[i]=(i+1)*(p->data_max)/nc;

/* Convert from array to array of arrays (puke!) */
  p_array=(float **)malloc(ny*sizeof(float *));
  for(i=0; i<ny; i++) {
    p_array[i]=&(p->data[i*nx]);
  }

/* Make x & y span from 0.0 to 1.0 */
  x=(float *)malloc(nx*sizeof(float));
  for(i=0; i<nx; i++)
    x[i]=(float )i/(float )(nx-1);
  y=(float *)malloc(ny*sizeof(float));
  for(i=0; i<ny; i++)
    y[i]=(float )i/(float )(ny-1);

/* Have to swap X & Y due to CRAZY array storage */
  ncontour_lines=0;
  i=conrec(p_array, 0,ny-1,0,nx-1, y,x, nc,z);
  printf("conrec calculates %d contour lines\n",ncontour_lines);

/* Return with values accumulated by add_contour_line() */
  p->lines=contour_lines;
  p->nlines=ncontour_lines;
}



/* Routine called by 'conrec' to add a straight line to contour */
void add_contour_line(float x1, float y1,
                      float x2, float y2,   float z) {

/* Die complaining if too many lines */
  if(ncontour_lines == 100000) {
      printf("ERROR: Too many contour lines\n");
      exit(1);
  }

/* Have to swap X & Y to compensate for calc_contour_lines() */
  ++ncontour_lines;
  contour_lines[ncontour_lines].y1=x1;
  contour_lines[ncontour_lines].x1=y1;
  contour_lines[ncontour_lines].y2=x2;
  contour_lines[ncontour_lines].x2=y2;
  contour_lines[ncontour_lines].z =z;
}
