/* Structure to store monitor data read from file */
struct mcstas_mon_file {
    int itype;
    char *source;
    char *date;
    char *component;
    char *file;
    char *x_label;
    char *y_label;
    float xlo,xhi,ylo,yhi;
    int nx,ny;
    float *data;
};

/* Structure to store 2D monitor data for display as an image */
struct mc2d_image_2d {
    int x_width,y_height;
    float *data;
    int nlines;
    struct mc2d_contour_line *lines;
    float data_max;
    char *component;
    char *x_label;
    char *y_label;
    float xlo,xhi,ylo,yhi;
};


/* Structure to define a single line element used for drawing contours */
struct mc2d_contour_line {
    float x1,y1,x2,y2,z;
};



/* Routines for parsing and reading simulation and monitor files */
int init_mon_files(int *n0, int *n1, int *n2);
struct mcstas_mon_file *get_2d_mon_file(int n);


/* Routines used for calculating contours */
void calc_contour_lines(struct mc2d_image_2d *p, int nc);
int conrec(float **d, int ilb,int iub,int jlb,int jub,
                        float *x,float *y, int nc,float *z);
void add_contour_line(float x1, float y1,
                      float x2, float y2,   float z);


/* Some useful macros */
#define MAX(a,b) ( ((a)<(b)) ? (b) : (a) )
#define MIN(a,b) ( ((a)>(b)) ? (b) : (a) )
#define SQR(a) ((a)*(a))

