#include <string.h>
#include <math.h>
#include <GL/glui.h>
#include "parser.h"

void draw_all_components(int *visibility);
void draw_neutron_tracks(struct mcstas_neutron_track *tracks, int ntracks);
int neutron_track_parser(struct mcstas_neutron_track *neutron_tracks,
                                  int first_neutron, int last_neutron,
                                                       char *file_name);


float xy_aspect;

int *components_visibility=NULL;

/* The number of neutrons that are generating for tracing */
int num_trace_neutrons=0;

/* The individual neutron tracks from component
   to component and the number of such tracks   */
int num_neutron_tracks=0;
struct mcstas_neutron_track {
    int component;
    float x1,y1,z1, x2,y2,z2;
};
struct mcstas_neutron_track *neutron_tracks=NULL;


char trace_file_name[200];


int trace_display_block=1;
int trace_block_size=10;


int   main_window;

float scale = 1.0;
float zshrink = 1.0;
float view_rotate[16] = { 1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1 };
float obj_pos[] = { 0.0, 0.0, 0.0 };

// Used by origin list-box
int origin_select=0;
float origin[]={0.0, 0.0, 0.0};

/** Pointers to the windows and some of the controls we'll create **/
GLUI *glui2;
GLUI_Checkbox   *checkbox;
GLUI_Spinner    *spinner;
GLUI_RadioGroup *radio;
GLUI_Panel      *obj_panel;

GLUI_Spinner *display_block_spinner;
GLUI_Spinner *block_size_spinner;

/*************************************** default sizes routines *******************/

int default_thickness=0;
int default_border=30;
int default_infinite=1000;

float get_default_thickness(void)
{
  if(default_thickness == 0)
    return 1e-5;

  return 0.001*default_thickness;
}

float get_default_border(void)
{
  return 0.001*default_border;
}

float get_default_infinite(void)
{
  return 0.001*default_infinite;
}


/*************************************** load_stipple_pattern() *******************/

void load_stipple_pattern(void)
{
 unsigned char pattern[140];
 int i;

/* Generate a pleasing stipple */
  for(i=0; i<4; i=i+2) {
    pattern[i   ]=pattern[i+9 ]=17;
    pattern[i+4 ]=pattern[i+13]=17<<2;
    pattern[i+1 ]=pattern[i+8 ]=17<<1;
    pattern[i+5 ]=pattern[i+12]=17<<3;
  }
  for(i=0; i<16; i++)
    pattern[i+16]=pattern[i]<<1;
  for(i=0; i<32; i++)
    pattern[i+32]=pattern[i];
  for(i=0; i<64; i++)
    pattern[i+64]=pattern[i]>>1;

/* Load the stipple pattern */
 glPolygonStipple(pattern);
}


/**************************************** control_cb() *******************/

/**** GLUI control callback *****/
void control_cb( int control )
{
}

void trace_display_cb(int idummy)
{
  int ncomp;

  if(trace_block_size <= 0) {
    display_block_spinner->set_int_limits( 1, MAX(1,num_trace_neutrons) );
    return;
  }

  display_block_spinner->set_int_limits( 1, MAX(1,num_trace_neutrons/trace_block_size));

  ncomp=get_num_components();
  free(neutron_tracks);
  neutron_tracks=(struct mcstas_neutron_track *)malloc(
		trace_block_size*ncomp*sizeof(struct mcstas_neutron_track) );
  num_neutron_tracks=neutron_track_parser(neutron_tracks,
				1+(trace_display_block-1)*trace_block_size,
                                trace_display_block*trace_block_size,
                                                           trace_file_name);

  glutPostRedisplay();
}


/**************************************** myGlutKeyboard() **********/

void myGlutKeyboard(unsigned char Key, int x, int y)
{
  switch(Key)
  {
  case 27: 
  case 'q':
    exit(0);
    break;
  };
  
  glutPostRedisplay();
}


/***************************************** myGlutMenu() ***********/

void myGlutMenu(int item)
{
  myGlutKeyboard( item, 0, 0 );
}


/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  /* According to the GLUT specification, the current window is 
     undefined during an idle callback.  So we need to explicitly change
     it if necessary */
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  

  /*  GLUI_Master.sync_live_all();  -- not needed - nothing to sync in this
                                       application  */

  glutPostRedisplay();
}


/***************************************** myGlutMotion() **********/

void myGlutMotion(int x, int y )
{
  glutPostRedisplay(); 
}


/**************************************** myGlutReshape() *************/

void myGlutReshape( int x, int y )
{
  int tx, ty, tw, th;
  GLUI_Master.get_viewport_area( &tx, &ty, &tw, &th );
  glViewport( tx, ty, tw, th );

  xy_aspect = (float)tw / (float)th;

  glutPostRedisplay();
}


/***************************************** myGlutDisplay() *****************/

void myGlutDisplay( void )
{
  int i;

  glClearColor( 0.6,0.7,1.0, 1.0 );
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glFrustum( -xy_aspect*.04, xy_aspect*.04, -.04, .04, .1, 15.0 );

  glMatrixMode( GL_MODELVIEW );

  glLoadIdentity();
  glTranslatef( 0.0, 0.0, -1.0 );
  glTranslatef( obj_pos[0], obj_pos[1], -obj_pos[2] ); 

  glMultMatrixf( view_rotate );
  glRotatef( 180.0, 0.707, 0.0, 0.707);
  glRotatef(-150.0, 0.0,   0.0, 1.0);
  glRotatef( -15.0, 0.0,   1.0, 0.0);

  glScalef( scale, scale, scale*zshrink );

  get_component(origin_select+1);
  get_component_pos(origin);
  glTranslatef( -origin[0], -origin[1], -origin[2] );

  draw_all_components(components_visibility);

  draw_neutron_tracks(neutron_tracks,num_neutron_tracks);

  glutSwapBuffers(); 
}


/***************************************** myGlutMouse() **********/

void myGlutMouse(int button, int button_state, int x, int y )
{
//  if( button == GLUT_LEFT_BUTTON && button_state == GLUT_DOWN )
//     pick_component( x, y );
}


/************************************* create panels *****************/

/*** Create the object movement panel ***/
void create_motion_panel(void)
{
  int i, n;

/**** Create subwindow on right of main window *****/
  glui2 = GLUI_Master.create_glui_subwindow( main_window, GLUI_SUBWINDOW_RIGHT );
  glui2->set_main_gfx_window( main_window );

/**** Listbox for changing origin to different components ****/
  GLUI_Listbox *origin_listbox =
    glui2->add_listbox( "Origin:", &origin_select );

  n=get_num_components();
  for(i=0; i<n; i++) {
    get_component(i+1);
    origin_listbox->add_item( i, get_component_name() );
  }

/***** Controls for object translation *****/
  GLUI_Panel *trans_panel = glui2->add_panel( "" );

  glui2->add_statictext_to_panel(trans_panel, "   Shift-mouse for large" );
  glui2->add_statictext_to_panel(trans_panel, "   movement, Ctrl-mouse" );
  glui2->add_statictext_to_panel(trans_panel, "   for small movement" );

  GLUI_Panel *trans_panel2 =
    glui2->add_panel_to_panel(trans_panel, "", GLUI_PANEL_NONE );

  GLUI_Translation *trans_xy =
    glui2->add_translation_to_panel(trans_panel2, "X & Y", GLUI_TRANSLATION_XY, obj_pos );
  trans_xy->set_speed( .005 );

  glui2->add_column_to_panel(trans_panel2, false);

  GLUI_Translation *trans_z =
    glui2->add_translation_to_panel(trans_panel2, "Z ", GLUI_TRANSLATION_Z, &obj_pos[2] );
  trans_z->set_speed( .005 );

/***** Control for rotating view *****/
  GLUI_Rotation *view_rot =
    glui2->add_rotation_to_panel(trans_panel, "Rotation", view_rotate );

/***** Controls for scaling objects *****/
  GLUI_Spinner *scale_spinner =
    glui2->add_spinner("Scale:",
				GLUI_SPINNER_FLOAT, &scale);
  scale_spinner->set_float_limits( 0.01, 10.0 );

  GLUI_Spinner *zshrink_spinner = 
    glui2->add_spinner("Zscale:",
                                GLUI_SPINNER_FLOAT, &zshrink);
  zshrink_spinner->set_float_limits( 0.01, 1.0 );

/**** Setup rollout for component visibility check boxes ****/
  GLUI_Panel *visibility_panel = glui2->add_rollout( "Visibility", false );

  n=get_num_components();
  components_visibility=(int *)malloc( n*sizeof(int) );

  for(i=0; i<n; i++) {
    get_component(i+1);
    components_visibility[i]=true;
    glui2->add_checkbox_to_panel( visibility_panel,
                                         get_component_name(),
                                         (components_visibility+i) );
    if(i == 15)
      glui2->add_column_to_panel(visibility_panel, true);
  }


/***** Controls for changing default object sizes *****/
  GLUI_Panel *defaults_panel = glui2->add_rollout( "Default Sizes", false );

  GLUI_Spinner *thickness_spinner =
    glui2->add_spinner_to_panel(defaults_panel, "Thickness (mm)",
                               GLUI_SPINNER_INT, &default_thickness);
  thickness_spinner->set_int_limits( 0, 99 );

  GLUI_Spinner *border_spinner =
    glui2->add_spinner_to_panel(defaults_panel, "Slit Borders (mm)",
                               GLUI_SPINNER_INT, &default_border);
  border_spinner->set_int_limits( 1, 99 );

  GLUI_Spinner *infinite_spinner =
    glui2->add_spinner_to_panel(defaults_panel, "Large Plate (mm)",
                               GLUI_SPINNER_INT, &default_infinite);
  infinite_spinner->set_int_limits( 100, 9999 );


/***** Controls for changing neutron traces to display *****/
  GLUI_Panel *traces_panel = glui2->add_rollout( "Neutron Traces", false );

  trace_block_size=1;
  trace_display_block=1;

  display_block_spinner =
    glui2->add_spinner_to_panel(traces_panel, "Display Block",
                               GLUI_SPINNER_INT, &trace_display_block,
				0, trace_display_cb);
  display_block_spinner->set_int_limits( 1, MAX(1,num_trace_neutrons/trace_block_size) );
  display_block_spinner->set_speed( 0.0 );

  block_size_spinner =
    glui2->add_spinner_to_panel(traces_panel, "Block Size",
                               GLUI_SPINNER_INT, &trace_block_size,
				0, trace_display_cb);
  block_size_spinner->set_int_limits( 1, num_trace_neutrons );

/****** A 'quit' button *****/
  glui2->add_button( "Quit", 0,(GLUI_Update_CB)exit );
}


/****************************************************** main ***********/


void main(int argc, char* argv[])
{
  int ncomp, nvectors;
  GLfloat ambient[] = { 0.0, 0.0, 0.0, 1.0 };
  GLfloat diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
  GLfloat position[] = { 1.0, 5.0, 2.0, 0.0 };
  GLfloat position2[] = { 1.0, 2.0,-5.0, 0.0 };
  GLfloat lmodel_ambient[] = { 0.4, 0.4, 0.4, 1.0 };
  GLfloat local_view[] = { 0.0 };

#ifdef _BORLAND	/* Disable FP exceptions handler */
  borland_GL_setup();
#endif

/**** Read in McSTAS output file containing component description ****/
  num_trace_neutrons=component_parser(argv[1]);
  ncomp=get_num_components();
  printf("%d components found in simulation\n",ncomp);
  printf("%d trace neutrons found in simulation\n",num_trace_neutrons);

/****   Initialize GLUT and create window *****/
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  glutInitWindowPosition( 0, 0 );
  glutInitWindowSize( 700, 600 );
 
  main_window = glutCreateWindow( "GLUI Example 5" );
  glutDisplayFunc( myGlutDisplay );
  GLUI_Master.set_glutReshapeFunc( myGlutReshape );  
  GLUI_Master.set_glutKeyboardFunc( myGlutKeyboard );
  GLUI_Master.set_glutSpecialFunc( NULL );
  GLUI_Master.set_glutMouseFunc( myGlutMouse );
  glutMotionFunc( myGlutMotion );

/**** Set up OpenGL lights *****/
  glEnable(GL_LIGHTING);
//  glEnable(GL_NORMALIZE);  /* ???? */

  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
  glLightfv(GL_LIGHT0, GL_POSITION, position);
 
  glEnable(GL_LIGHT1);
  glLightfv(GL_LIGHT1, GL_AMBIENT, ambient);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
  glLightfv(GL_LIGHT1, GL_POSITION, position2);
 
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
  glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, local_view);

/**** Load a stipple pattern, but don't enable it! ****/
  load_stipple_pattern();

/**** Enable z-buffering ****/
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LESS);  /* ???? */

/**** Create GLUI panels ******/
  create_motion_panel();

/**** Link windows to GLUI, and register idle callback ******/
  glui2->set_main_gfx_window( main_window );

/**** We register the idle callback with GLUI, *not* with GLUT ****/
  GLUI_Master.set_glutIdleFunc( myGlutIdle );

/**** Store name of trace file and call callback to read data ****/
  strcpy(trace_file_name,argv[1]);
  trace_display_cb(0);

/**** Regular GLUT main loop ****/
  glutMainLoop();
}
