/************** Values defined in 'parser.cpp' ********************/

#define TOKEN_surface_infinite     1
#define TOKEN_axes                 2
#define TOKEN_box                  3
#define TOKEN_hollow_cylinder      4
#define TOKEN_hollow_cylinder_y    5
#define TOKEN_move                 6
#define TOKEN_render               7
#define TOKEN_slit_circle          8
#define TOKEN_slit_rectangle       9
#define TOKEN_surface_circle      10
#define TOKEN_surface_cylinder_y  11
#define TOKEN_surface_rectangle   12
#define TOKEN_surface_sphere      13
#define TOKEN_tube                14
#define TOKEN_tube_taper          15


/************** Types defined in 'parser.cpp' ********************/

struct mc3d_draw_list {
    int token,nargs;
    float args[7];
    struct mc3d_draw_list* next;
};


struct mc3d_component_list {
    char *name;
    float pos[3], rot[9];
    struct mc3d_draw_list* draw_list;
    struct mc3d_component_list* next;
};


/************** Routines defined in 'parser.cpp' ********************/

int component_parser(char *file_name);

int get_num_components(void);
void get_component(int num);
int get_named_component(char *name);
char* get_component_name(void);
void get_component_pos(float *pos);
void get_component_rot(float *rot);

int get_num_draw_objects(void);
void get_draw_object(int num);
int get_draw_object_token(void);
int get_draw_object_args(float *args);


#ifndef MAX(a,b)
# define MAX(a,b) ((a)>(b)?(a):(b))
# define MIN(a,b) ((a)<(b)?(a):(b))
#endif
